<?php
/**
 * The template for displaying product category thumbnails within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product_cat.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.1
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $woocommerce_loop,$woo_cat_counter;

$term 			= get_queried_object();
$parent_id 		= empty( $term->term_id ) ? 0 : $term->term_id;

$product_categories = get_categories( apply_filters( 'woocommerce_product_subcategories_args', array(
	'parent'       => $parent_id,
	'menu_order'   => 'ASC',
	'hide_empty'   => 0,
	'hierarchical' => 1,
	'taxonomy'     => 'product_cat',
	'pad_counts'   => 1
) ) );

$category_count = count($product_categories);
$woo_cat_counter = $woo_cat_counter > 1 ? $woo_cat_counter : 1 ;


// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) )
	$woocommerce_loop['loop'] = 0;

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) )
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );

?>

<?php
	if ( $woocommerce_loop['loop']  % $woocommerce_loop['columns'] == 0 || $woocommerce_loop['columns'] == 1){
		echo ' <div class="row">';
	}
?>

<div <?php wc_product_cat_class("col col-sm-3 product-category product", $category); ?>>

	<?php
	/**
	 * woocommerce_before_subcategory hook.
	 *
	 * @hooked woocommerce_template_loop_category_link_open - 10
	 */
	do_action( 'woocommerce_before_subcategory', $category );

	/**
	 * woocommerce_before_subcategory_title hook.
	 *
	 * @hooked woocommerce_subcategory_thumbnail - 10
	 */
	do_action( 'woocommerce_before_subcategory_title', $category );

	/**
	 * woocommerce_shop_loop_subcategory_title hook.
	 *
	 * @hooked woocommerce_template_loop_category_title - 10
	 */
	do_action( 'woocommerce_shop_loop_subcategory_title', $category );

	/**
	 * woocommerce_after_subcategory_title hook.
	 */
	do_action( 'woocommerce_after_subcategory_title', $category );

	/**
	 * woocommerce_after_subcategory hook.
	 *
	 * @hooked woocommerce_template_loop_category_link_close - 10
	 */
	do_action( 'woocommerce_after_subcategory', $category ); ?>


</div>

<?php
	if ( $woocommerce_loop['loop'] % $woocommerce_loop['columns'] == 0 || $woo_cat_counter == $category_count ){
		echo '</div>';
	}
	
	$woo_cat_counter++;
?>