/**
 * Grunt tasks file for RT-Theme 19 WordPress Theme
 * Created by RT-Themes
 * http://rtthemes.com
 *
 * use 'grunt release' for production
 * use 'grunt watch' for sass development
 * 
 * do js min
 * do css min
 * do compass compile
 * do combine css
 * do combine js
 */

module.exports = function(grunt) {

  grunt.loadNpmTasks('grunt-contrib-cssmin');
  grunt.loadNpmTasks('grunt-compass-multiple');
  grunt.loadNpmTasks('grunt-contrib-watch');
  grunt.loadNpmTasks('grunt-contrib-clean');
  grunt.loadNpmTasks('grunt-contrib-concat');
  grunt.loadNpmTasks('grunt-contrib-uglify');

  grunt.initConfig({

      //--------------------------
      // compass compile at multi threads.
      //--------------------------
      compassMultiple: {
        options : {
          javascriptsDir: 'rttheme19/js',
          imagesDir: 'rttheme19/images',
          sassDir: 'rttheme19/css/sass',
          cssDir: 'rttheme19/css',
          relativeAssets: true,
        },

        // Release
        release: {
          options: {
            environment: 'production', 
            outputStyle: 'expanded',
            multiple: [
              {
                // admin
                sassDir: 'rttheme19/rt-framework/admin/css/sass',
                cssDir: 'rttheme19/rt-framework/admin/css'
              },{
                // theme
                sassDir: 'rttheme19/css/sass',
                cssDir: 'rttheme19/css'
              }
            ],            
          }
        },

        // Debug
        debug: {
          options: {
            environment: 'development', 
            outputStyle: 'expanded',
            multiple: [
              {
                // admin
                sassDir: 'rttheme19/rt-framework/admin/css/sass',
                cssDir: 'rttheme19/rt-framework/admin/css'
              },{
                // theme
                sassDir: 'rttheme19/css/sass',
                cssDir: 'rttheme19/css'
              }
            ],            
          }
        } 

      },


      //--------------------------
      // css min
      //--------------------------
      cssmin: {
        all: {
          files: [{
            expand: true,
            cwd: 'rttheme19/css',
            src: ['*.css', '!*.min.css'],
            dest: 'rttheme19/css',
            ext: '.min.css'
          }]
        },
        layout1: {
          files: [{
            expand: true,
            cwd: 'rttheme19/css/layout1',
            src: ['*.css', '!*.min.css'],
            dest: 'rttheme19/css/layout1',
            ext: '.min.css'
          }]
        },  
        layout2: {
          files: [{
            expand: true,
            cwd: 'rttheme19/css/layout2',
            src: ['*.css', '!*.min.css'],
            dest: 'rttheme19/css/layout2',
            ext: '.min.css'
          }]
        },   
        layout3: {
          files: [{
            expand: true,
            cwd: 'rttheme19/css/layout3',
            src: ['*.css', '!*.min.css'],
            dest: 'rttheme19/css/layout3',
            ext: '.min.css'
          }]
        },     
        layout4: {
          files: [{
            expand: true,
            cwd: 'rttheme19/css/layout4',
            src: ['*.css', '!*.min.css'],
            dest: 'rttheme19/css/layout4',
            ext: '.min.css'
          }]
        },                                 
        woo: {
          files: [{
            expand: true,
            cwd: 'rttheme19/css/woocommerce',
            src: ['*.css', '!*.min.css'],
            dest: 'rttheme19/css/woocommerce',
            ext: '.min.css'
          }]
        },      
        admin: {
          files: [{
            expand: true,
            cwd: 'rttheme19/rt-framework/admin/css',
            src: ['*.css', '!*.min.css'],
            dest: 'rttheme19/rt-framework/admin/css',
            ext: '.min.css'
          }]
        },                
       // combine: {
       //   files: {
       //     'rttheme19/css/app.min.css': ['rttheme19/css/!app.min.css','rttheme19/css/!*.css', 'rttheme19/css/*.min.css']
       //   }
       // }        
      },

      //--------------------------
      // concat 
      //--------------------------
      concat: {
        options: {
          separator: '',
        },
        layout1: {
          src: [
                'rttheme19/css/layout1/bootstrap.css',
                'rttheme19/css/owl-carousel.min.css',
                'rttheme19/css/lightbox/lightgallery.min.css',
                'rttheme19/css/layout1/style.min.css'
              ],
          dest: 'rttheme19/css/layout1/app.min.css',
        },
        layout2: {
          src: [
                'rttheme19/css/layout2/bootstrap.css',
                'rttheme19/css/owl-carousel.min.css',
                'rttheme19/css/lightbox/lightgallery.min.css',
                'rttheme19/css/layout2/style.min.css'
              ],
          dest: 'rttheme19/css/layout2/app.min.css',
        },  
        layout3: {
          src: [
                'rttheme19/css/layout3/bootstrap.css',
                'rttheme19/css/owl-carousel.min.css',
                'rttheme19/css/lightbox/lightgallery.min.css',
                'rttheme19/css/layout3/style.min.css'
              ],
          dest: 'rttheme19/css/layout3/app.min.css',
        },   
        layout4: {
          src: [
                'rttheme19/css/layout4/bootstrap.css',
                'rttheme19/css/owl-carousel.min.css',
                'rttheme19/css/lightbox/lightgallery.min.css',
                'rttheme19/css/layout4/style.min.css'
              ],
          dest: 'rttheme19/css/layout4/app.min.css',
        },                        
        extras1: {
          src: [
                'rttheme19/js/pace.js',
                'rttheme19/js/modernizr.min.js',
                'rttheme19/js/imagesloaded.min.js',
                'rttheme19/js/isotope.pkgd.min.js',
                'rttheme19/js/owl.carousel.min.js',
                'rttheme19/js/customselect.min.js',
                'rttheme19/js/jflickrfeed.min.js',
                'rttheme19/js/bootstrap.min.js',
                'rttheme19/js/waypoints.min.js',
                'rttheme19/js/placeholders.min.js',
                'rttheme19/js/jquery.vide.min.js',
                'rttheme19/js/lightgallery-all.min.js',
                'rttheme19/js/layout1/scripts.min.js',
          ],
          dest: 'rttheme19/js/layout1/app.min.js',
        },        

        extras2: {
          src: [
                'rttheme19/js/pace.js',
                'rttheme19/js/modernizr.min.js',
                'rttheme19/js/imagesloaded.min.js',
                'rttheme19/js/isotope.pkgd.min.js',
                'rttheme19/js/owl.carousel.min.js',
                'rttheme19/js/customselect.min.js',
                'rttheme19/js/jflickrfeed.min.js',
                'rttheme19/js/bootstrap.min.js',
                'rttheme19/js/waypoints.min.js',
                'rttheme19/js/placeholders.min.js',
                'rttheme19/js/jquery.vide.min.js',
                'rttheme19/js/lightgallery-all.min.js',
                'rttheme19/js/layout2/scripts.min.js',
          ],
          dest: 'rttheme19/js/layout2/app.min.js',
        },    

        extras3: {
          src: [
                'rttheme19/js/pace.js',
                'rttheme19/js/modernizr.min.js',
                'rttheme19/js/imagesloaded.min.js',
                'rttheme19/js/isotope.pkgd.min.js',
                'rttheme19/js/owl.carousel.min.js',
                'rttheme19/js/customselect.min.js',
                'rttheme19/js/jflickrfeed.min.js',
                'rttheme19/js/bootstrap.min.js',
                'rttheme19/js/waypoints.min.js',
                'rttheme19/js/placeholders.min.js',
                'rttheme19/js/jquery.vide.min.js',
                'rttheme19/js/lightgallery-all.min.js',
                'rttheme19/js/TweenLite.min.js',
                'rttheme19/js/layout3/scripts.min.js',
          ],
          dest: 'rttheme19/js/layout3/app.min.js',
        },

        extras4: {
          src: [
                'rttheme19/js/pace.js',
                'rttheme19/js/modernizr.min.js',
                'rttheme19/js/imagesloaded.min.js',
                'rttheme19/js/isotope.pkgd.min.js',
                'rttheme19/js/owl.carousel.min.js',
                'rttheme19/js/customselect.min.js',
                'rttheme19/js/jflickrfeed.min.js',
                'rttheme19/js/bootstrap.min.js',
                'rttheme19/js/waypoints.min.js',
                'rttheme19/js/placeholders.min.js',
                'rttheme19/js/jquery.vide.min.js',
                'rttheme19/js/lightgallery-all.min.js',
                'rttheme19/js/TweenLite.min.js',
                'rttheme19/js/layout4/scripts.min.js',
          ],
          dest: 'rttheme19/js/layout4/app.min.js',
        },

        mainjs_1: {
          src: [
                'rttheme19/js/app/pool/vendors.js',
                'rttheme19/js/app/pool/start.js',
                'rttheme19/js/app/settings.js',    
                'rttheme19/js/app/layout1/misc.js',         
                'rttheme19/js/app/common.js',                             
                'rttheme19/js/app/layout1/mobile-menu.js',
                'rttheme19/js/app/layout1/drop-right-menu.js',
                'rttheme19/js/app/pool/fixed-footer-vertical.js',
                'rttheme19/js/app/pool/tools-menu-vertical.js',
                'rttheme19/js/app/pool/add-to-cart-flying.js',
                'rttheme19/js/app/pool/end.js',
          ],
          dest: 'rttheme19/js/layout1/scripts.js',
        },  

        mainjs_2: {
          src: [
                'rttheme19/js/app/pool/vendors.js',
                'rttheme19/js/app/pool/start.js',
                'rttheme19/js/app/settings.js',
                'rttheme19/js/app/common.js',
                'rttheme19/js/app/layout2/misc.js',
                'rttheme19/js/app/layout2/mobile-menu.js',
                'rttheme19/js/app/layout2/sticky-header.js',
                'rttheme19/js/app/pool/horizontal-header-elements.js',                
                'rttheme19/js/app/layout2/drop-down-menu.js',
                'rttheme19/js/app/pool/fixed-footer-horizontal.js',
                'rttheme19/js/app/pool/tools-menu-horizontal.js',
                'rttheme19/js/app/pool/add-to-cart-flying.js',
                'rttheme19/js/app/pool/end.js',
          ],
          dest: 'rttheme19/js/layout2/scripts.js',
        },  

        mainjs_3: {
          src: [
                'rttheme19/js/app/pool/vendors.js',
                'rttheme19/js/app/pool/start.js',
                'rttheme19/js/app/settings.js',
                'rttheme19/js/app/common.js',
                'rttheme19/js/app/pool/side_panel.js',
                'rttheme19/js/app/pool/mobile-menu.js',
                'rttheme19/js/app/layout3/sticky-header.js', 
                'rttheme19/js/app/pool/horizontal-header-elements.js',                
                'rttheme19/js/app/layout3/drop-down-menu.js',
                'rttheme19/js/app/pool/fixed-footer-horizontal.js',
                'rttheme19/js/app/pool/add-to-cart-side.js',
                'rttheme19/js/app/pool/end.js',
          ],
          dest: 'rttheme19/js/layout3/scripts.js',
        },  
 
         mainjs_4: {
          src: [
                'rttheme19/js/app/pool/vendors.js',
                'rttheme19/js/app/pool/start.js',
                'rttheme19/js/app/settings.js',
                'rttheme19/js/app/common.js',
                'rttheme19/js/app/pool/side_panel.js',
                'rttheme19/js/app/pool/mobile-menu.js',
                'rttheme19/js/app/layout4/sticky-header.js', 
                'rttheme19/js/app/pool/horizontal-header-elements.js',                
                'rttheme19/js/app/layout4/drop-down-menu.js',
                'rttheme19/js/app/pool/fixed-footer-horizontal.js',
                'rttheme19/js/app/pool/add-to-cart-side.js',
                'rttheme19/js/app/pool/end.js',
          ],
          dest: 'rttheme19/js/layout4/scripts.js',
        },  

      },

      //--------------------------
      // clean 
      //--------------------------
      clean: {
        css: [  
                'rttheme19/**/.DS_Store',
                'rttheme19/css/layout1/bootstrap.css',
                'rttheme19/css/layout1/style.css', 
                'rttheme19/css/layout1/rtl.css', 

                'rttheme19/css/layout2/bootstrap.css',
                'rttheme19/css/layout2/style.css', 
                'rttheme19/css/layout2/rtl.css', 

                'rttheme19/css/layout3/bootstrap.css',
                'rttheme19/css/layout3/style.css', 
                'rttheme19/css/layout3/rtl.css', 

                'rttheme19/css/layout4/bootstrap.css',
                'rttheme19/css/layout4/style.css', 
                'rttheme19/css/layout4/rtl.css', 

                'rttheme19/css/ie9.css', 
                'rttheme19/css/woocommerce/rt-woocommerce.css', 
                "rttheme19/rt-framework/admin/css/admin.css"
              ]
      },

      //--------------------------
      // Uglify 
      //--------------------------
      uglify: {
        options: {
          preserveComments: 'some'
        },
        dist1: {
            src: ['rttheme19/js/layout1/scripts.js'],
            dest: 'rttheme19/js/layout1/scripts.min.js',          
        },
        dist2: {
            src: ['rttheme19/js/layout2/scripts.js'],
            dest: 'rttheme19/js/layout2/scripts.min.js'            
        },   
        dist3: {
            src: ['rttheme19/js/layout3/scripts.js'],
            dest: 'rttheme19/js/layout3/scripts.min.js'            
        },      
        dist4: {
            src: ['rttheme19/js/layout4/scripts.js'],
            dest: 'rttheme19/js/layout4/scripts.min.js'            
        },                        
        admin: {
            files : {
              'rttheme19/rt-framework/admin/js/script.min.js' : 'rttheme19/rt-framework/admin/js/script.js',
              'rttheme19/rt-framework/admin/js/customizer.min.js' : 'rttheme19/rt-framework/admin/js/customizer.js',
              'rttheme19/rt-framework/admin/js/rt-skin-selector.min.js' : 'rttheme19/rt-framework/admin/js/rt-skin-selector.js',
              'rttheme19/rt-framework/admin/js/rt-font-control.min.js' : 'rttheme19/rt-framework/admin/js/rt-font-control.js',
              'rttheme19/rt-framework/admin/js/rt-color-control.min.js' : 'rttheme19/rt-framework/admin/js/rt-color-control.js', 
              'rttheme19/rt-framework/admin/js/editor_buttons.min.js' : 'rttheme19/rt-framework/admin/js/editor_buttons.js'
            }            
        }        
      },

      //--------------------------
      // watch
      //--------------------------
      watch: {
        dev: {
          files: [
            'rttheme19/rt-framework/admin/css/**/*.scss',
            'rttheme19/css/**/*.scss',
            '*.css',
            '!*.min.css',
            'rttheme19/js/app/**/*.js',
          ],
          tasks: [
            'default'
          ]
        }    
      },
  });
 
  // Default Task
  grunt.registerTask('default', ['compassMultiple:debug','concat:mainjs_1','concat:mainjs_2','concat:mainjs_3','concat:mainjs_4' ]); 

  // Release Task
  grunt.registerTask('release', ['clean:css','compassMultiple:release','uglify','cssmin','concat']); 

};